<?php
/*--------------------------------------------------------------
   WidgetDatabaseEntry.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Height;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\HorizontalPosition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Label;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\UpdateSet;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\VerticalPosition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Width;

class WidgetDatabaseEntry
{
    /**
     * @var Id|null
     */
    private $id;
    
    /**
     * @var Type
     */
    private $type;
    
    /**
     * @var Label
     */
    private $label;
    
    /**
     * @var Width
     */
    private $width;
    
    /**
     * @var Height
     */
    private $height;
    
    /**
     * @var HorizontalPosition
     */
    private $horizontalPosition;
    
    /**
     * @var VerticalPosition
     */
    private $verticalPosition;
    
    /**
     * @var UpdateSet
     */
    private $updateSet;
    
    
    /**
     * Constructor.
     */
    public function __construct(
        Type $type,
        Label $label,
        Width $width,
        Height $height,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition,
        UpdateSet $updateSet,
        ?Id $id
    ) {
        $this->id                 = $id;
        $this->type               = $type;
        $this->label              = $label;
        $this->width              = $width;
        $this->height             = $height;
        $this->horizontalPosition = $horizontalPosition;
        $this->verticalPosition   = $verticalPosition;
        $this->updateSet          = $updateSet;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(
        Type $type,
        Label $label,
        Width $width,
        Height $height,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition,
        UpdateSet $updateSet,
        ?Id $id
    ): self {
        return new self($type, $label, $width, $height, $horizontalPosition, $verticalPosition, $updateSet, $id);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): ?Id
    {
        return $this->id;
    }
    
    
    /**
     * Return type.
     */
    public function type(): Type
    {
        return $this->type;
    }
    
    
    /**
     * Return label.
     */
    public function label(): Label
    {
        return $this->label;
    }
    
    
    /**
     * Return width.
     */
    public function width(): Width
    {
        return $this->width;
    }
    
    
    /**
     * Return height.
     */
    public function height(): Height
    {
        return $this->height;
    }
    
    
    /**
     * Return horizontal position.
     */
    public function horizontalPosition(): HorizontalPosition
    {
        return $this->horizontalPosition;
    }
    
    
    /**
     * Return vertical position.
     */
    public function verticalPosition(): VerticalPosition
    {
        return $this->verticalPosition;
    }
    
    
    /**
     * Return option update set.
     */
    public function updateSet(): UpdateSet
    {
        return $this->updateSet;
    }
}